//=============================================================================
// MedKit.
//=============================================================================
class HealVial extends DeusExPickup;

var int healAmount;

var const int HealAmounts[5];
var const String Ranks[5];

var travel int Rank;
var travel string ConfirmationString;

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 if (ConfirmationString == "")
 {
  ConfirmationString = "Randomized";
  Rank = Rand(5);
 }
 
 UpdateStats();
}

function TravelPostAccept()
{
 Super.TravelPostAccept();
 
 UpdateStats();
}

function UpdateStats()
{
 HealAmount = HealAmounts[Rank];
 ItemName = "|cbc3d41"$Ranks[Rank]$"Heal Vial";
 Description = "Replenishes "$HealAmount$" health upon use";
}

// ----------------------------------------------------------------------
state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer player;
		
		Super.BeginState();

		player = DeusExPlayer(Owner);
		if (player != None)
		{
			player.HealPlayer(healAmount, False);

				WipeAcid(); //destroy our acid effects
				player.StopPoison();
				player.ExtinguishFire();
				player.drugEffectTimer = 0;
				PlaySound(sound'MedicalHiss');
		}

		UseOnce();
	}
Begin:
}

function WipeAcid()
{
 local AcidMold M;
 
 forEach AllActors(class'AcidMold', M)
 {
  if (M.Moldee == Owner) M.Destroy();
 }
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 9);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     healAmount=50
     //maxCopies=1
     //bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="|cbc3d41Heal Vial"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.LiquorBottle'
     PickupViewMesh=LodMesh'DeusExItems.LiquorBottle'
     ThirdPersonMesh=LodMesh'DeusExItems.LiquorBottle'
     LandSound=Sound'DeusExSounds.Generic.GlassHit1'
     Icon=Texture'DeusExUI.Icons.BeltIconLiquorBottle'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLiquorBottle'
     largeIconWidth=20
     largeIconHeight=48
     Description="Replenishes 50 health upon use"
     beltDescription="|cbc3d41HEAL"
     Mesh=LodMesh'DeusExItems.LiquorBottle'
     CollisionRadius=4.620000
     CollisionHeight=12.500000
     Mass=10.000000
     Buoyancy=8.000000
     Ranks(0)="Minor "
     Ranks(1)="Light "
     Ranks(2)=""
     Ranks(3)="Greater "
     Ranks(4)="Grand "
     HealAmounts(0)=20
     HealAmounts(1)=40
     HealAmounts(2)=60
     HealAmounts(3)=80
     HealAmounts(4)=100
}
